#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""

       Universite catholique de Louvain
       CEREM : Centre for research in mechatronics
       http://www.robotran.be
       Contact : info@robotran.be


       Main script template for complete model:
       -----------------------------------------------
        This template loads the data file *.mbs and execute:
          - the coordinate partitioning module
          - the direct dynamic module (time integration of
            equations of motion).
          - the equilibrium module
          - the modal module

        (c) Universite catholique de Louvain

        Project : a five-point suspension
        Author: Sebastien Timmermans
        Date: January 2020

"""

#==============================================================================
# Packages loading
#==============================================================================
import MBsysPy as Robotran


#==============================================================================
# Project loading
#==============================================================================
mbs_data = Robotran.MbsData("../dataR/five_point_suspension_python.mbs")
#mbs_comp_F_sensor(mbs_data, 0, 1)
mbs_data.__load_symbolic_fct__(Robotran.mbs_data.__MODULE_DIR__, ["sensor"], mbs_data.symbolic_path)
mbs_data.__assign_symb_fct__(["sensor"])
mbs_data.sensors[0].comp_s_sensor(1)
# print(mbs_data.sensors[0].P[1], mbs_data.sensors[0].P[2], mbs_data.sensors[0].P[3])

mbs_data.q0[1] = 0.278

#==============================================================================
# Partitionning
#==============================================================================
mbs_data.process = 1
mbs_part = Robotran.MbsPart(mbs_data)
mbs_part.set_options(rowperm = 1, verbose = 1)
mbs_part.run()

#==============================================================================
# Equilibrium
#==============================================================================
mbs_data.process = 2
mbs_data.q[1] = mbs_data.q0[1] #0.3
mbs_equil = Robotran.MbsEquil(mbs_data)
mbs_equil.add_exchange_um("SUSP","z0", 4) #replace variable for the equilibrium
mbs_equil.set_options(method = 1, senstol = 1e-6, verbose = 1)
mbs_equil.run()
# print(mbs_data.q[10], mbs_data.q[11])

print('equil',mbs_data.user_model['SUSP']['z0'])

# #==============================================================================
# # Modal Analysis
# #==============================================================================
# mbs_data.process = 4
# mbs_modal = Robotran.MbsModal(mbs_data)
# mbs_modal.set_options(save_result = 1, save_anim = 1, mode_ampl = 0.2)
# mbs_modal.run()

#==============================================================================
# Kinematics
#==============================================================================

### First kinematics to reach the lower bumpstop (smoothly)
mbs_data.process = 50

mbs_data.set_qdriven(mbs_data.joint_id["R1_chassis_barre2"])
mbs_solvekin = Robotran.MbsSolvekin(mbs_data)

# Set the motion to be solved as a trajectory
mbs_solvekin.set_options(motion = "trajectory")

# Provide the time interval and time step to solve the inverse kinematics.
mbs_solvekin.set_options(t0 = 0.0, tf = 1.0, dt = 1e-3)

mbs_solvekin.run()


### Second kinematics to get the suspension kinematics from lower bumpstop to upper bumpstop
mbs_data.process = 51


mbs_dirdyn = Robotran.MbsDirdyn(mbs_data)

# Set the motion to be solved as a trajectory
#mbs_dirdyn.set_options(motion = "trajectory")

# Provide the time interval and time step to solve the inverse kinematics.
mbs_dirdyn.set_options(t0 = 0.0, tf = 1.0, dt0 = 1e-3)

mbs_dirdyn.run()

#==============================================================================
# Direct Dynamics
#==============================================================================
print('dirdyn',mbs_data.user_model['SUSP']['z0'])

mbs_data.process = 30

mbs_data.set_qu(mbs_data.joint_id["R1_chassis_barre2"])
mbs_data.q[:] = mbs_data.q0[:]
# mbs_data.q0[1] = mbs_data.q0[1]
mbs_dirdyn = Robotran.MbsDirdyn(mbs_data)
mbs_dirdyn.set_options(resfilename = 'dirdyn', dt0 = 1e-3, tf = 1.0, save2file = 1)
mbs_dirdyn.run()

mbs_data.process = 31
mbs_data.q[:] = mbs_data.q0[:]
# mbs_data.q0[1] = mbs_data.q0[1]
mbs_dirdyn = Robotran.MbsDirdyn(mbs_data)
mbs_dirdyn.set_options(resfilename = 'sweep', dt0 = 1e-3, tf = 20.0, save2file = 1, buffersize=1)
mbs_dirdyn.run()
